<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreUpload.php";
    include "../classi/GeneratoreUrl.php";
    include "../include/costanti.php";
    include "../include/util.php";

    session_start();
    if(!isset($_SESSION["geecomUser_email"])) {
        header("Location: index.php");
        exit();
    }
    else {
        $geecomDb = new DbManager($costantiDatabase);
        
        //prendo i valori dalla form
        $nome           = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
        $cognome        = filter_input(INPUT_POST,"cognome",FILTER_SANITIZE_ADD_SLASHES);
        $email          = $geecomDb->escapeString($_POST["email"]);
        $telefono       = filter_input(INPUT_POST,"telefono",FILTER_SANITIZE_ADD_SLASHES);
        $via            = filter_input(INPUT_POST,"via",FILTER_SANITIZE_ADD_SLASHES);
        $citta          = filter_input(INPUT_POST,"citta",FILTER_SANITIZE_ADD_SLASHES);
        $cap            = filter_input(INPUT_POST,"cap",FILTER_SANITIZE_STRING);
        $codiceFiscale  = filter_input(INPUT_POST,"codiceFiscale",FILTER_SANITIZE_STRING);
        $partitaIva     = filter_input(INPUT_POST,"partitaIva",FILTER_SANITIZE_STRING);
        $organizzazione = filter_input(INPUT_POST,"organizzazione",FILTER_SANITIZE_ADD_SLASHES);
        $pec            = filter_input(INPUT_POST,"pec",FILTER_SANITIZE_STRING);
        $codiceInterscambio = filter_input(INPUT_POST,"codiceInterscambio",FILTER_SANITIZE_STRING);
        
        $queryAggiornamentoUtente ="UPDATE geec_utenti SET nome='$nome', cognome='$cognome', telefono='$telefono', organizzazione='$organizzazione', citta = '$citta', cap='$cap', email='$email', via='$via', codiceFiscale='$codiceFiscale', partitaIva='$partitaIva', pec='$pec', codiceInterscambio='$codiceInterscambio' WHERE id={$_SESSION["geecomUser_id"]}";
        $geecomDb->eseguiQueryScrittura($queryAggiornamentoUtente);
        
        $impostazioni = recuperaImpostazioni($geecomDb);
        $pagina       = $geecomDb->leggiSingolaRiga("geecAd_contenuti", $impostazioni["paginaProfilo"]);
        $linkPagina   = GeneratoreUrl::creaUrlContenuto($pagina, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlPiattaforma"]);
        header("Location: $linkPagina&status=100");
    }